/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsCollectionWithSizeTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsCollectionWithSize.hasSize((int)7);
    }

    public void testMatchesWhenSizeIsCorrect() {
        IsCollectionWithSizeTest.assertMatches("correct size", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)2)), Arrays.asList(null, null));
        IsCollectionWithSizeTest.assertMismatchDescription("collection size was <3>", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)2)), Arrays.asList(null, null, null));
    }

    public void testMatchesCollectionWhenSizeIsCorrectUsingObjectElementType() {
        List<Object> list = Arrays.asList(null, null);
        IsCollectionWithSizeTest.assertMatches("correct size", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)2)), list);
        IsCollectionWithSizeTest.assertMismatchDescription("collection size was <2>", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)3)), list);
    }

    public void testMatchesCollectionWhenSizeIsCorrectUsingStringElementType() {
        List<String> list = Arrays.asList("a", "b");
        IsCollectionWithSizeTest.assertMatches("correct size", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)2)), list);
        IsCollectionWithSizeTest.assertMismatchDescription("collection size was <2>", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)3)), list);
    }

    public void testMatchesCollectionWhenSizeIsCorrectUsingWildcardElementType() {
        List<String> list = Arrays.asList("a", "b");
        IsCollectionWithSizeTest.assertMatches("correct size", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)2)), list);
        IsCollectionWithSizeTest.assertMismatchDescription("collection size was <2>", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)3)), list);
    }

    public void testMatchesListWhenSizeIsCorrectUsingObjectElementType() {
        List<Object> list = Arrays.asList(null, null);
        IsCollectionWithSizeTest.assertMatches("correct size", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)2)), list);
        IsCollectionWithSizeTest.assertMismatchDescription("collection size was <2>", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)3)), list);
    }

    public void testMatchesListWhenSizeIsCorrectUsingStringElementType() {
        List<String> list = Arrays.asList("a", "b");
        IsCollectionWithSizeTest.assertMatches("correct size", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)2)), list);
        IsCollectionWithSizeTest.assertMismatchDescription("collection size was <2>", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)3)), list);
    }

    public void testMatchesListWhenSizeIsCorrectUsingWildcardElementType() {
        List<String> list = Arrays.asList("a", "b");
        IsCollectionWithSizeTest.assertMatches("correct size", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)2)), list);
        IsCollectionWithSizeTest.assertMismatchDescription("collection size was <2>", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)3)), list);
    }

    public void testProvidesConvenientShortcutForHasSizeEqualTo() {
        IsCollectionWithSizeTest.assertMatches("correct size", IsCollectionWithSize.hasSize((int)2), Arrays.asList(null, null));
        IsCollectionWithSizeTest.assertMismatchDescription("collection size was <3>", IsCollectionWithSize.hasSize((int)2), Arrays.asList(null, null, null));
    }

    public void testHasAReadableDescription() {
        IsCollectionWithSizeTest.assertDescription("a collection with size <3>", IsCollectionWithSize.hasSize((Matcher)IsEqual.equalTo((Object)3)));
    }

    public void testCompilesWithATypedCollection() {
        ArrayList arrayList = new ArrayList();
        MatcherAssert.assertThat(arrayList, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }
}

